(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 5/15/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'models/contact/ContactModel', 'views/contact/ContactView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, ContactModel, ContactView) {
    var CompanyView;
    return CompanyView = class CompanyView extends Backbone.View {
      initialize(usr, company1) {
        this.usr = usr;
        this.company = company1;
        //#console.log 'Company View Init '
        return this.company.on('change', this.update_details, this);
      }

      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-ul-company-contacts > li': 'btnContactClicked'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['CompanyView'];
        this.$el.html(template({
          usr: this.usr.toJSON(),
          company: this.company.toJSON()
        }));
        this.$el.attr('id', 'id-CompanyView');
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      update_details(mdl) {
        var cName, company, contact, fullName, li, ul;
        company = mdl.get('Company');
        cName = company.name;
        $('#id-header-company-name').text(cName);
        ul = $('#id-ul-company-contacts');
        ul.empty();
        if (_.isArray(company.Contact)) {
          _.each(company.Contact, function(contact) {
            var fullName, li;
            if (contact.fullName === '') {
              fullName = 'No Name Set';
            } else {
              fullName = contact.fullName;
            }
            li = `<li data-contactID=\"${contact.contactID}\">`;
            li += "<span class=\"fwi-contact object-span\"/>";
            li += `<span class=\"header\">${fullName}</span>`;
            li += `<span class=\"subheader1\">${cName}</span>`;
            li += "<span class='fwi-arrow-right arrow-right'/></li>";
            li += "</li>";
            return ul.append(li);
          });
        } else {
          contact = company.Contact;
          if (contact.fullName === '') {
            fullName = 'No Name Set';
          } else {
            fullName = contact.fullName;
          }
          li = `<li data-contactID=\"${contact.contactID}\">`;
          li += "<span class=\"fwi-contact object-span\"/>";
          li += `<span class=\"header\">${fullName}</span>`;
          li += `<span class=\"subheader1\">${cName}</span>`;
          li += "<span class='fwi-arrow-right arrow-right'/></li>";
          li += "</li>";
          ul.append(li);
        }
        return ul.listview('refresh');
      }

      btnContactClicked(event) {
        var contact, contactID, obj, view;
        event.preventDefault();
        event.stopPropagation();
        if (!ContactView) {
          ContactView = require("views/contact/ContactView");
        }
        obj = $(event.currentTarget);
        contactID = obj.attr('data-contactID');
        contact = new ContactModel();
        contact.get_details_contact(this.usr.get('sessionID'), contactID);
        view = new ContactView(this.usr, contact);
        return this.__go_to_contact_view(view);
      }

      __go_to_contact_view(view) {
        var index, nextView;
        nextView = _.find($.mobile.jqmNavigator.getViews(), function(view) {
          return $(view.el).attr('id') === 'id-ContactView';
        });
        if (nextView) {
          index = _.chain($.mobile.jqmNavigator.getViews()).pluck("cid").indexOf(nextView.cid).value();
          //#console.log 'INDEX '+index
          $.mobile.jqmNavigator.getViews().splice(index, 1);
          $('#id-ContactView').remove();
        }
        //  $.mobile.jqmNavigator.pushView(nextView,{ transition: "none"})
        //else
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnBackClicked() {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
